/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public class TreeItem extends Item {
	Tree parent;
	TreeItem parentItem;

public TreeItem (Tree parent, int style) {
	this (parent, style, -1);
}

public TreeItem (Tree parent, int style, int index) {
	super (parent, style, index);
}

public TreeItem (TreeItem parentItem, int style) {
	this(parentItem, style, -1);
}

public TreeItem (TreeItem parentItem, int style, int index) {
	super (parentItem, style, index);
}

protected void checkSubclass () {
}

public void clear (int index, boolean all) {
}

public void clearAll (boolean all) {
}

void createWidget(Display display, Widget parent, int style, int index) {
	this.display = display;
	if (parent instanceof TreeItem) {
		this.parentItem = (TreeItem) parent;
		this.parent = this.parentItem.parent;
	} else {
		this.parentItem = null;
		this.parent = (Tree) parent;
	}
	int newIndex = index;
	if (index==-1) { newIndex = parentItem!=null ? this.parentItem.getItemCount() : this.parent.getItemCount(); }
	this.parent.createItem (parent, this, style, newIndex);
	hookEvents ();
	register ();
	text = "";
}

public Color getBackground () {
	return null;
}

public Color getBackground (int index) {
	return null;
}

public Rectangle getBounds () {
	return null;
}

public Rectangle getBounds (int index) {
	return null;
}

public boolean getChecked () {
	return false;
}

public boolean getExpanded () {
	return false;
}

public Font getFont () {
	return null;
}

public Font getFont (int index) {
	return null;
}

public Color getForeground () {
	return null;
}

public Color getForeground (int index) {
	return null;
}

public boolean getGrayed () {
	return false;
}

public TreeItem getItem (int index) {
	checkWidget ();
	if (index < 0 || index>=getItemCount()) error (SWT.ERROR_INVALID_RANGE);
//	if (!parent.checkData (this, true)) error (SWT.ERROR_WIDGET_DISPOSED);
	return parent.items[_getItem (index)]; 
}

public int getItemCount () {
	return _getItemCount ();
}

public TreeItem[] getItems () {
	checkWidget();
	TreeItem [] items = new TreeItem[getItemCount()];
	for (int i=0; i<getItemCount(); i++){
		items[i] = getItem(i);
	}
	return items;
}

public Image getImage () {
	return null;
}

public Image getImage (int index) {
	return null;
}

public Rectangle getImageBounds (int index) {
	return null;
}

public Tree getParent () {
	return parent;
}

public TreeItem getParentItem () {
	return parentItem;
}

public String getText () {
	return getText(0);
}

public String getText (int index) {
	return text;
}

public Rectangle getTextBounds (int index) {
	return null;
}

void hookEvents () {
	_hookEvents("onmousedown", 	SWT.MouseDown);
	_hookEvents("onfocus", 		SWT.FocusIn);
	_hookEvents("onblur", 		SWT.FocusOut);
}

public int indexOf (TreeItem item) {
	checkWidget();
	if (item == null) error (SWT.ERROR_NULL_ARGUMENT);
	TreeItem [] items = getItems ();
	for (int i=0; i<items.length; i++) {
		if (items [i] == item) return i;
	}
	return -1;
}

void releaseWidget () {
	super.releaseWidget ();
	parentItem = null;
}

public void removeAll () {
}

public void setBackground (Color color) {
}

public void setBackground (int index, Color color) {
}

public void setChecked (boolean checked) {
}

public void setExpanded (boolean expanded) {
}

public void setFont (Font font) {
}

public void setFont (int index, Font font) {
}

public void setForeground (Color color) {
}

public void setForeground (int index, Color color) {
}

public void setGrayed (boolean grayed) {
}

public void setImage (Image[] images) {
}

public void setImage (int index, Image image) {
	checkWidget();
	_setImage(index, image.imagePath);
}

public void setImage (Image image) {
	checkWidget ();
	setImage(0, image);
}

public void setItemCount (int count) {
	checkWidget ();
	count = Math.max (0, count);
	parent.setItemCount (count);
}

public void setText (String[] strings) {
	checkWidget();
	if (strings == null) error (SWT.ERROR_NULL_ARGUMENT);
	for (int i=0; i<strings.length; i++) {
		String string = strings [i];
		if (string != null) setText (i, string);
	}
}

public void setText (int index, String string) {
}

public void setText (String string) {
	super.setText(string);
	_setText(string);
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createItem (Widget parent, int style, int index, int indexInArray) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.TreeItem"]){
		$wnd.dojo._hasResource["org.eclipse.swt.TreeItem"] = true;
		$wnd.dojo.provide("org.eclipse.swt.TreeItem");
		
		$wnd.dojo.require("org.eclipse.swt.Tree");
	
		$wnd.dojo.declare("org.eclipse.swt.TreeItem", $wnd.dijit._TreeNode, {
			hasIcon: false,
			indexInArray: -1,
			_updateItemClasses: function (){},
			addChild: function (child, index){
				this.state = "LOADED";
				if(!this.containerNode){
					this.containerNode = this.tree.containerNodeTemplate.cloneNode(true);
					this.domNode.appendChild(this.containerNode);					
	        		this.makeExpandable();
				}
	        	this.inherited("addChild", arguments);
	        	$wnd.dojo.forEach(this.getChildren(), function(child){
					child._updateLayout();
				});
				if(this.containerNode && !this._wipeIn){
					this._wipeIn = $wnd.dojo.fx.wipeIn({node: this.containerNode, duration: 150});
					this._wipeOut = $wnd.dojo.fx.wipeOut({node: this.containerNode, duration: 150});
				}
	        	return child;
	        },
        	postCreate: function(){
				this.inherited("postCreate", arguments);
				$wnd.swt.setCssStyle(this.domNode,{zoom: 0});
				$wnd.dojo.addClass(this.iconNode,"swtTreeItemNoIcon");
				$wnd.dojo.removeClass(this.iconNode,"dijitTreeIcon");
			},
			setImage: function(image){
				$wnd.dojo.removeClass(this.iconNode,"swtTreeItemNoIcon");
				this.iconNode.innerHTML = "<img src='"+image+"'/>";
			},
		});
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var params = {};
	params.tree = jsParent.tree;
	params.indexInArray = indexInArray;
	var self = new $wnd.org.eclipse.swt.TreeItem(params); 
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self, index);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

native int _getItem (int index) /*-{
	return this.@org.eclipse.swt.widgets.Widget::jsObject.getChildren()[index].indexInArray;  
}-*/;

native int _getItemCount () /*-{
	return this.@org.eclipse.swt.widgets.Widget::jsObject.getChildren().length;
}-*/;

native void _setText (String string) /*-{
	this.@org.eclipse.swt.widgets.Widget::jsObject.setLabelNode(string);
}-*/;

native void _setImage (int index, String image) /*-{
	this.@org.eclipse.swt.widgets.Widget::jsObject.setImage(image);	
}-*/;

}
